/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.hardware.massStorage.DiskNode;
import jace.hardware.massStorage.FileNode;
import jace.hardware.massStorage.ProdosVirtualDisk;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryNode
extends DiskNode
implements FileFilter {
    public static int FILE_ENTRY_SIZE = 39;

    public DirectoryNode(ProdosVirtualDisk ownerFilesystem, File physicalDir, int baseBlock) throws IOException {
        this.setBaseBlock(baseBlock);
        this.init(ownerFilesystem, physicalDir);
    }

    public DirectoryNode(ProdosVirtualDisk ownerFilesystem, File physicalDir) throws IOException {
        this.init(ownerFilesystem, physicalDir);
    }

    private void init(ProdosVirtualDisk ownerFilesystem, File physicalFile) throws IOException {
        this.setPhysicalFile(physicalFile);
        this.setType(DiskNode.EntryType.SUBDIRECTORY);
        this.setName(physicalFile.getName());
        this.setOwnerFilesystem(ownerFilesystem);
    }

    public void doDeallocate() {
    }

    public void doAllocate() {
        File[] files = this.physicalFile.listFiles(this);
        int numEntries = files.length;
        int numBlocks = 1;
        if (numEntries > 12) {
            numBlocks += (numEntries - 12) / 13;
        }
        for (File f : files) {
            this.addFile(f);
        }
        Collections.sort(this.children, new Comparator<DiskNode>(){

            @Override
            public int compare(DiskNode o1, DiskNode o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public void doRefresh() {
    }

    public boolean checkFile() throws IOException {
        File[] realFileList;
        boolean success = true;
        if (!super.checkFile()) {
            return false;
        }
        HashSet<String> realFiles = new HashSet<String>();
        for (File f : realFileList = this.physicalFile.listFiles(this)) {
            realFiles.add(f.getName());
        }
        Iterator<DiskNode> i = this.getChildren().iterator();
        while (i.hasNext()) {
            DiskNode node = i.next();
            if (realFiles.contains(node.getPhysicalFile().getName())) {
                realFiles.remove(node.getPhysicalFile().getName());
            } else {
                i.remove();
                success = false;
            }
            if (!node.isAllocated() || node instanceof DirectoryNode || node.checkFile()) continue;
            success = false;
        }
        if (!realFiles.isEmpty()) {
            success = false;
            for (String fileName : realFiles) {
                this.addFile(new File(this.physicalFile, fileName));
            }
        }
        return success;
    }

    public void readBlock(int block, byte[] buffer) throws IOException {
        this.checkFile();
        if (block == 0) {
            this.generateHeader(buffer);
            for (int i = 0; i < 12 && i < this.children.size(); ++i) {
                this.generateFileEntry(buffer, 4 + (i + 1) * FILE_ENTRY_SIZE, i);
            }
        } else {
            int start = block * 13 - 1;
            int end = start + 13;
            int offset = 4;
            for (int i = start; i < end && i < this.children.size(); ++i) {
                this.generateFileEntry(buffer, offset, i);
                offset += FILE_ENTRY_SIZE;
            }
        }
    }

    public boolean accept(File file) {
        if (file.getName().endsWith("~")) {
            return false;
        }
        char c = file.getName().charAt(0);
        if (c == '.' || c == '~') {
            return false;
        }
        return !file.isHidden();
    }

    private void generateHeader(byte[] buffer) {
        this.generateWord(buffer, 0, 0);
        int nextBlock = 0;
        if (!this.additionalNodes.isEmpty()) {
            nextBlock = ((DiskNode)this.additionalNodes.get((int)0)).baseBlock;
        }
        this.generateWord(buffer, 2, nextBlock);
        buffer[4] = (byte)((this.baseBlock == 2 ? 240 : 224) + this.getName().length());
        this.generateName(buffer, 5, this);
        for (int i = 20; i <= 27; ++i) {
            buffer[i] = 0;
        }
        this.generateTimestamp(buffer, 28, this.getPhysicalFile().lastModified());
        buffer[32] = 25;
        buffer[33] = 0;
        buffer[34] = 3;
        buffer[35] = (byte)FILE_ENTRY_SIZE;
        buffer[36] = 13;
        this.generateWord(buffer, 37, this.children.size());
        this.generateWord(buffer, 39, this.ownerFilesystem.freespaceBitmap.baseBlock);
        this.generateWord(buffer, 41, 65535);
    }

    private void generateFileEntry(byte[] buffer, int offset, int fileNumber) throws IOException {
        DiskNode child = (DiskNode)this.children.get(fileNumber);
        buffer[offset] = (byte)((child.getType().code << 4) + child.getName().length());
        this.generateName(buffer, offset + 1, child);
        buffer[offset + 16] = (byte)(child instanceof DirectoryNode ? 15 : ((FileNode)child).fileType);
        this.generateWord(buffer, offset + 17, child.getBaseBlock());
        this.generateWord(buffer, offset + 19, 1 + child.additionalNodes.size());
        int length = (int)child.physicalFile.length() & 0xFFFFFF;
        this.generateWord(buffer, offset + 21, length & 0xFFFF);
        buffer[offset + 23] = (byte)(length >> 16 & 0xFF);
        this.generateTimestamp(buffer, offset + 24, child.physicalFile.lastModified());
        buffer[offset + 28] = 25;
        buffer[offset + 29] = 0;
        buffer[offset + 30] = -1;
        if (child instanceof FileNode) {
            this.generateWord(buffer, offset + 31, ((FileNode)child).loadAddress);
        }
        this.generateTimestamp(buffer, offset + 33, child.physicalFile.lastModified());
        this.generateWord(buffer, offset + 37, this.getBaseBlock());
    }

    private void generateTimestamp(byte[] buffer, int offset, long date) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date);
        buffer[offset + 2] = (byte)(c.get(2) >> 3 & 1);
        buffer[offset + 3] = (byte)((c.get(2) & 7) + c.get(5) & 0xFF);
        buffer[offset + 0] = (byte)c.get(11);
        buffer[offset + 1] = (byte)c.get(12);
    }

    private void generateWord(byte[] buffer, int i, int value) {
        buffer[i] = (byte)(value & 0xFF);
        buffer[i + 1] = (byte)(value >> 8 & 0xFF);
    }

    private void generateName(byte[] buffer, int offset, DiskNode node) {
        for (int i = 0; i < node.getName().length(); ++i) {
            buffer[offset + i] = (byte)node.getName().charAt(i);
        }
    }

    private void addFile(File file) {
        try {
            if (file.isDirectory()) {
                this.addChild(new DirectoryNode(this.getOwnerFilesystem(), file));
            } else {
                this.addChild(new FileNode(this.getOwnerFilesystem(), file));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DirectoryNode.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

